/*
 * Decompiled with CFR 0.152.
 */
public class Mesh {
    public int maxIndex = 0;
    public int numVertices = 0;
    public int numFaces = 0;
    public int numTextures = 0;
    public int[] verticesY;
    public int[] verticesZ;
    public short[] facesA;
    public short[] facesB;
    public short[] facesC;
    public byte[] textureMappings;
    public short[] facesTexture;
    public byte[] facesType;
    public short[] aShortArray1144;
    public short[] triangleIdentifiers;
    public int[] vertexSkins;
    public byte[] facesPriority;
    public byte[] facesAlpha;
    public short[] facesColor;
    public short[] facesMaterial;
    public int[] facesSkins;
    public byte priority = 0;
    public int version = 12;
    public int[] textureSpeed;
    public byte[] textureRotation;
    public short[] textureMappingP;
    public short[] textureMappingM;
    public short[] textureMappingN;
    public int[] textureScaleX;
    public byte[] textureDirection;
    public int[] textureScaleZ;
    public int[] verticesX;
    public int[] textureTransU;
    public int[] textureTransV;
    public int[] textureScaleY;
    public EmissiveTriangle[] emitters;
    public EffectiveVertex[] effectors;
    public Billboard[] billboards;
    public int numUVCoords;
    public float[] textureCoordU;
    public float[] textureCoordV;
    public byte[] texCoordVertexA;
    public byte[] texCoordVertexB;
    public byte[] texCoordVertexC;
    public int[] vertexUVOffset;

    public Mesh(int _numVertices, int _numFaces, int _numTextures) {
        this.verticesX = new int[_numVertices];
        this.verticesY = new int[_numVertices];
        this.verticesZ = new int[_numVertices];
        this.vertexSkins = new int[_numVertices];
        this.facesA = new short[_numFaces];
        this.facesB = new short[_numFaces];
        this.facesC = new short[_numFaces];
        this.facesType = new byte[_numFaces];
        this.facesPriority = new byte[_numFaces];
        this.facesAlpha = new byte[_numFaces];
        this.facesTexture = new short[_numFaces];
        this.facesColor = new short[_numFaces];
        this.facesMaterial = new short[_numFaces];
        this.facesSkins = new int[_numFaces];
        if (_numTextures > 0) {
            this.textureMappings = new byte[_numTextures];
            this.textureMappingP = new short[_numTextures];
            this.textureMappingM = new short[_numTextures];
            this.textureMappingN = new short[_numTextures];
            this.textureScaleX = new int[_numTextures];
            this.textureScaleY = new int[_numTextures];
            this.textureScaleZ = new int[_numTextures];
            this.textureRotation = new byte[_numTextures];
            this.textureDirection = new byte[_numTextures];
            this.textureSpeed = new int[_numTextures];
            this.textureTransU = new int[_numTextures];
            this.textureTransV = new int[_numTextures];
        }
    }

    public Mesh(Mesh[] meshes, int numMeshes) {
        this.numVertices = 0;
        this.numFaces = 0;
        this.numTextures = 0;
        this.numUVCoords = 0;
        int numEmitters = 0;
        int numEffectors = 0;
        int numBillboards = 0;
        boolean hasRenderTypes = false;
        boolean hasPriorities = false;
        boolean hasAlphas = false;
        boolean hasTextureCoords = false;
        boolean hasMaterials = false;
        boolean hasSkins = false;
        this.priority = (byte)-1;
        int index = 0;
        while (index < numMeshes) {
            Mesh mesh = meshes[index];
            if (mesh != null) {
                this.numVertices += mesh.numVertices;
                this.numFaces += mesh.numFaces;
                this.numTextures += mesh.numTextures;
                this.numUVCoords += mesh.numUVCoords;
                if (mesh.emitters != null) {
                    numEmitters += mesh.emitters.length;
                }
                if (mesh.effectors != null) {
                    numEffectors += mesh.effectors.length;
                }
                if (mesh.billboards != null) {
                    numBillboards += mesh.billboards.length;
                }
                hasRenderTypes |= mesh.facesType != null;
                if (mesh.facesPriority != null) {
                    hasPriorities = true;
                } else {
                    if (this.priority == -1) {
                        this.priority = mesh.priority;
                    }
                    if (this.priority != mesh.priority) {
                        hasPriorities = true;
                    }
                }
                hasAlphas |= mesh.facesAlpha != null;
                hasTextureCoords |= mesh.facesTexture != null;
                hasMaterials |= mesh.facesMaterial != null;
                hasSkins |= mesh.facesSkins != null;
            }
            ++index;
        }
        this.verticesX = new int[this.numVertices];
        this.verticesY = new int[this.numVertices];
        this.verticesZ = new int[this.numVertices];
        this.vertexSkins = new int[this.numVertices];
        this.triangleIdentifiers = new short[this.numVertices];
        this.facesA = new short[this.numFaces];
        this.facesB = new short[this.numFaces];
        this.facesC = new short[this.numFaces];
        if (hasRenderTypes) {
            this.facesType = new byte[this.numFaces];
        }
        if (hasPriorities) {
            this.facesPriority = new byte[this.numFaces];
        }
        if (hasAlphas) {
            this.facesAlpha = new byte[this.numFaces];
        }
        if (hasTextureCoords) {
            this.facesTexture = new short[this.numFaces];
        }
        this.facesColor = new short[this.numFaces];
        if (hasMaterials) {
            this.facesMaterial = new short[this.numFaces];
        }
        if (hasSkins) {
            this.facesSkins = new int[this.numFaces];
        }
        this.aShortArray1144 = new short[this.numFaces];
        if (this.numTextures > 0) {
            this.textureMappings = new byte[this.numTextures];
            this.textureMappingP = new short[this.numTextures];
            this.textureMappingM = new short[this.numTextures];
            this.textureMappingN = new short[this.numTextures];
            this.textureScaleX = new int[this.numTextures];
            this.textureScaleY = new int[this.numTextures];
            this.textureScaleZ = new int[this.numTextures];
            this.textureRotation = new byte[this.numTextures];
            this.textureDirection = new byte[this.numTextures];
            this.textureSpeed = new int[this.numTextures];
            this.textureTransU = new int[this.numTextures];
            this.textureTransV = new int[this.numTextures];
        }
        if (numBillboards > 0) {
            this.billboards = new Billboard[numBillboards];
        }
        if (numEmitters > 0) {
            this.emitters = new EmissiveTriangle[numEmitters];
        }
        if (numEffectors > 0) {
            this.effectors = new EffectiveVertex[numEffectors];
        }
        if (this.numUVCoords > 0) {
            this.textureCoordU = new float[this.numUVCoords];
            this.textureCoordV = new float[this.numUVCoords];
            this.vertexUVOffset = new int[this.numVertices];
            this.texCoordVertexA = new byte[this.numFaces];
            this.texCoordVertexB = new byte[this.numFaces];
            this.texCoordVertexC = new byte[this.numFaces];
        }
        int[] is = new int[this.numVertices];
        int[] is_187_ = new int[this.numUVCoords];
        int[] particlesVertexBuffer = new int[this.numVertices];
        int[] texturesVertexBuffer = new int[this.numVertices];
        int[] faceIndiceBuffer = new int[3];
        this.numVertices = 0;
        this.numFaces = 0;
        this.numTextures = 0;
        this.numUVCoords = 0;
        numEmitters = 0;
        numEffectors = 0;
        numBillboards = 0;
        int index2 = 0;
        while (index2 < numMeshes) {
            short identifier = (short)(1 << index2);
            Mesh mesh = meshes[index2];
            int faceOffset = this.numFaces;
            if (mesh != null) {
                boolean[] calculatedUV = new boolean[mesh.numVertices];
                if (mesh.billboards != null) {
                    int billboardIndex = 0;
                    while (billboardIndex < mesh.billboards.length) {
                        Billboard billboard = mesh.billboards[billboardIndex];
                        this.billboards[numBillboards++] = billboard.translateFace(billboard.face + this.numFaces);
                        ++billboardIndex;
                    }
                }
                int faceIndex = 0;
                while (faceIndex < mesh.numFaces) {
                    faceIndiceBuffer[0] = mesh.facesA[faceIndex];
                    faceIndiceBuffer[1] = mesh.facesB[faceIndex];
                    faceIndiceBuffer[2] = mesh.facesC[faceIndex];
                    int axis = 0;
                    while (axis < 3) {
                        int face = faceIndiceBuffer[axis];
                        int x = mesh.verticesX[face];
                        int y = mesh.verticesY[face];
                        int z = mesh.verticesZ[face];
                        int vertex = 0;
                        while (vertex < this.numVertices) {
                            if (x == this.verticesX[vertex] && y == this.verticesY[vertex] && z == this.verticesZ[vertex]) {
                                int n = vertex;
                                this.triangleIdentifiers[n] = (short)(this.triangleIdentifiers[n] | identifier);
                                particlesVertexBuffer[face] = vertex;
                                break;
                            }
                            ++vertex;
                        }
                        if (mesh.numUVCoords > 0 && !calculatedUV[face]) {
                            int i_203_ = (face < mesh.numVertices - 1 ? mesh.vertexUVOffset[face + 1] : mesh.numUVCoords) - mesh.vertexUVOffset[face];
                            int i_204_ = 0;
                            while (i_204_ < i_203_) {
                                this.textureCoordU[this.numUVCoords] = mesh.textureCoordU[mesh.vertexUVOffset[face] + i_204_];
                                this.textureCoordV[this.numUVCoords] = mesh.textureCoordV[mesh.vertexUVOffset[face] + i_204_];
                                is_187_[this.numUVCoords] = vertex << 16 | is[vertex] + i_204_;
                                ++this.numUVCoords;
                                ++i_204_;
                            }
                            texturesVertexBuffer[face] = is[vertex];
                            int n = vertex;
                            is[n] = is[n] + i_203_;
                            calculatedUV[face] = true;
                        }
                        if (vertex >= this.numVertices) {
                            this.verticesX[this.numVertices] = x;
                            this.verticesY[this.numVertices] = y;
                            this.verticesZ[this.numVertices] = z;
                            this.triangleIdentifiers[this.numVertices] = identifier;
                            this.vertexSkins[this.numVertices] = mesh.vertexSkins != null ? mesh.vertexSkins[face] : -1;
                            particlesVertexBuffer[face] = this.numVertices++;
                        }
                        ++axis;
                    }
                    ++faceIndex;
                }
                faceIndex = 0;
                while (faceIndex < mesh.numFaces) {
                    if (hasRenderTypes && mesh.facesType != null) {
                        this.facesType[this.numFaces] = mesh.facesType[faceIndex];
                    }
                    if (hasPriorities) {
                        this.facesPriority[this.numFaces] = mesh.facesPriority != null ? mesh.facesPriority[faceIndex] : mesh.priority;
                    }
                    if (hasAlphas && mesh.facesAlpha != null) {
                        this.facesAlpha[this.numFaces] = mesh.facesAlpha[faceIndex];
                    }
                    if (hasMaterials) {
                        this.facesMaterial[this.numFaces] = mesh.facesMaterial != null ? mesh.facesMaterial[faceIndex] : -1;
                    }
                    if (hasSkins) {
                        this.facesSkins[this.numFaces] = mesh.facesSkins != null ? mesh.facesSkins[faceIndex] : -1;
                    }
                    if (mesh.numUVCoords > 0) {
                        this.texCoordVertexA[this.numFaces] = (byte)(mesh.texCoordVertexA[faceIndex] + texturesVertexBuffer[mesh.facesA[faceIndex]]);
                        this.texCoordVertexB[this.numFaces] = (byte)(mesh.texCoordVertexB[faceIndex] + texturesVertexBuffer[mesh.facesB[faceIndex]]);
                        this.texCoordVertexC[this.numFaces] = (byte)(mesh.texCoordVertexC[faceIndex] + texturesVertexBuffer[mesh.facesC[faceIndex]]);
                    }
                    this.facesA[this.numFaces] = (short)particlesVertexBuffer[mesh.facesA[faceIndex]];
                    this.facesB[this.numFaces] = (short)particlesVertexBuffer[mesh.facesB[faceIndex]];
                    this.facesC[this.numFaces] = (short)particlesVertexBuffer[mesh.facesC[faceIndex]];
                    this.aShortArray1144[this.numFaces] = identifier;
                    this.facesColor[this.numFaces] = mesh.facesColor[faceIndex];
                    ++this.numFaces;
                    ++faceIndex;
                }
                if (mesh.emitters != null) {
                    int emiiterIndex = 0;
                    while (emiiterIndex < mesh.emitters.length) {
                        int xOffset = particlesVertexBuffer[mesh.emitters[emiiterIndex].vertexA];
                        int yOffset = particlesVertexBuffer[mesh.emitters[emiiterIndex].vertexB];
                        int zOffset = particlesVertexBuffer[mesh.emitters[emiiterIndex].vertexC];
                        this.emitters[numEmitters] = mesh.emitters[emiiterIndex].method1063(mesh.emitters[emiiterIndex].type + faceOffset, xOffset, yOffset, zOffset);
                        ++numEmitters;
                        ++emiiterIndex;
                    }
                }
                if (mesh.effectors != null) {
                    int effectorIndex = 0;
                    while (effectorIndex < mesh.effectors.length) {
                        int point = particlesVertexBuffer[mesh.effectors[effectorIndex].skin];
                        this.effectors[numEffectors] = mesh.effectors[effectorIndex].translatePoint(point);
                        ++numEffectors;
                        ++effectorIndex;
                    }
                }
            }
            ++index2;
        }
        this.maxIndex = this.numVertices;
        if (this.numUVCoords > 0) {
            Mesh.quicksort(is_187_, this.textureCoordU, this.textureCoordV, (byte)-30);
            int i_213_ = 0;
            int i_212_ = 0;
            while (i_212_ < this.numVertices) {
                this.vertexUVOffset[i_212_] = i_213_;
                i_213_ += is[i_212_];
                ++i_212_;
            }
        }
        index2 = 0;
        int coord = 0;
        while (index2 < numMeshes) {
            short identifier = (short)(1 << index2);
            Mesh mesh = meshes[index2];
            if (mesh != null) {
                if (hasTextureCoords) {
                    int faceIndex = 0;
                    while (faceIndex < mesh.numFaces) {
                        int n = this.facesTexture[coord] = mesh.facesTexture != null ? mesh.facesTexture[faceIndex] : -1;
                        if (this.facesTexture[coord] > -1 && this.facesTexture[coord] < 32766) {
                            this.facesTexture[coord] = (short)(this.facesTexture[coord] + this.numTextures);
                        }
                        ++faceIndex;
                        ++coord;
                    }
                }
                int faceIndex = 0;
                while (faceIndex < mesh.numTextures) {
                    this.textureMappings[this.numTextures] = mesh.textureMappings[faceIndex];
                    byte mappingType = this.textureMappings[this.numTextures];
                    if (mappingType == 0) {
                        this.textureMappingP[this.numTextures] = (short)this.addVertex(mesh, (int)mesh.textureMappingP[faceIndex], identifier);
                        this.textureMappingM[this.numTextures] = (short)this.addVertex(mesh, (int)mesh.textureMappingM[faceIndex], identifier);
                        this.textureMappingN[this.numTextures] = (short)this.addVertex(mesh, (int)mesh.textureMappingN[faceIndex], identifier);
                    } else if (mappingType >= 1 && mappingType <= 3) {
                        this.textureMappingP[this.numTextures] = mesh.textureMappingP[faceIndex];
                        this.textureMappingM[this.numTextures] = mesh.textureMappingM[faceIndex];
                        this.textureMappingN[this.numTextures] = mesh.textureMappingN[faceIndex];
                        this.textureScaleX[this.numTextures] = mesh.textureScaleX[faceIndex];
                        this.textureScaleY[this.numTextures] = mesh.textureScaleY[faceIndex];
                        this.textureScaleZ[this.numTextures] = mesh.textureScaleZ[faceIndex];
                        this.textureRotation[this.numTextures] = mesh.textureRotation[faceIndex];
                        this.textureDirection[this.numTextures] = mesh.textureDirection[faceIndex];
                        this.textureSpeed[this.numTextures] = mesh.textureSpeed[faceIndex];
                    } else if (mappingType == 2) {
                        this.textureTransU[this.numTextures] = mesh.textureTransU[faceIndex];
                        this.textureTransV[this.numTextures] = mesh.textureTransV[faceIndex];
                    }
                    ++this.numTextures;
                    ++faceIndex;
                }
            }
            ++index2;
        }
    }

    public Mesh(byte[] data) {
        this.decodeRS3(data);
    }

    void decode(byte[] is) {
        int numBillboards;
        int face;
        int offset;
        boolean hasVersion;
        Packet first = new Packet(is);
        Packet second = new Packet(is);
        Packet third = new Packet(is);
        Packet fourth = new Packet(is);
        Packet fifth = new Packet(is);
        Packet sixth = new Packet(is);
        Packet seventh = new Packet(is);
        first.offset = is.length - 23;
        this.numVertices = first.readUnsignedShort();
        this.numFaces = first.readUnsignedShort();
        this.numTextures = first.readUnsignedByte();
        int flags = first.readUnsignedByte();
        boolean hasFaceTypes = (flags & 1) == 1;
        boolean hasParticleEffects = (flags & 2) == 2;
        boolean hasbillboards = (flags & 4) == 4;
        boolean bl = hasVersion = (flags & 8) == 8;
        if (hasVersion) {
            first.offset -= 7;
            this.version = first.readUnsignedByte();
            first.offset += 6;
        }
        int modelPriority = first.readUnsignedByte();
        int hasAlphas = first.readUnsignedByte();
        int hasFaceSkins = first.readUnsignedByte();
        int hasMaterials = first.readUnsignedByte();
        int hasVertexSkins = first.readUnsignedByte();
        int modelVerticesX = first.readUnsignedShort();
        int modelVerticesY = first.readUnsignedShort();
        int modelVerticesZ = first.readUnsignedShort();
        int modelVertexPoint = first.readUnsignedShort();
        int modelTextureCoords = first.readUnsignedShort();
        int simpleTextureFaceCount = 0;
        int complexTextureFaceCount = 0;
        int cubeTextureFaceCount = 0;
        if (this.numTextures > 0) {
            this.textureMappings = new byte[this.numTextures];
            first.offset = 0;
            int face2 = 0;
            while (face2 < this.numTextures) {
                this.textureMappings[face2] = first.readByte();
                byte type = this.textureMappings[face2];
                if (type == 0) {
                    ++simpleTextureFaceCount;
                }
                if (type >= 1 && type <= 3) {
                    ++complexTextureFaceCount;
                }
                if (type == 2) {
                    ++cubeTextureFaceCount;
                }
                ++face2;
            }
        }
        int verticesFlagOffset = offset = this.numTextures;
        int facesTypeOffset = offset += this.numVertices;
        if (hasFaceTypes) {
            offset += this.numFaces;
        }
        int facesCompressTypeOffset = offset;
        int facesPriorityOffset = offset += this.numFaces;
        if (modelPriority == 255) {
            offset += this.numFaces;
        }
        int facesSkinOffset = offset;
        if (hasFaceSkins == 1) {
            offset += this.numFaces;
        }
        int verticesSkinOffset = offset;
        if (hasVertexSkins == 1) {
            offset += this.numVertices;
        }
        int facesAlphaOffset = offset;
        if (hasAlphas == 1) {
            offset += this.numFaces;
        }
        int facesIndexOffset = offset;
        int facesMaterialOffset = offset += modelVertexPoint;
        if (hasMaterials == 1) {
            offset += this.numFaces * 2;
        }
        int facesTextureIndexOffset = offset;
        int facesColorOffset = offset += modelTextureCoords;
        int verticesXOffset = offset += this.numFaces * 2;
        int verticesYOffset = offset += modelVerticesX;
        int verticesZOffset = offset += modelVerticesY;
        int simpleTexturesOffset = offset += modelVerticesZ;
        int complexTexturesOffset = offset += simpleTextureFaceCount * 6;
        offset += complexTextureFaceCount * 6;
        int textureSize = 6;
        if (this.version == 14) {
            textureSize = 7;
        } else if (this.version >= 15) {
            textureSize = 9;
        }
        int texturesScaleOffset = offset;
        int texturesRotationOffset = offset += complexTextureFaceCount * textureSize;
        int texturesDirectionOffset = offset += complexTextureFaceCount;
        int texturesTranslationOffset = offset += complexTextureFaceCount;
        int particlesEffectOFfset = offset += complexTextureFaceCount + cubeTextureFaceCount * 2;
        this.verticesX = new int[this.numVertices];
        this.verticesY = new int[this.numVertices];
        this.verticesZ = new int[this.numVertices];
        this.facesA = new short[this.numFaces];
        this.facesB = new short[this.numFaces];
        this.facesC = new short[this.numFaces];
        if (hasVertexSkins == 1) {
            this.vertexSkins = new int[this.numVertices];
        }
        if (hasFaceTypes) {
            this.facesType = new byte[this.numFaces];
        }
        if (modelPriority == 255) {
            this.facesPriority = new byte[this.numFaces];
        } else {
            this.priority = (byte)modelPriority;
        }
        if (hasAlphas == 1) {
            this.facesAlpha = new byte[this.numFaces];
        }
        if (hasFaceSkins == 1) {
            this.facesSkins = new int[this.numFaces];
        }
        if (hasMaterials == 1) {
            this.facesMaterial = new short[this.numFaces];
        }
        if (hasMaterials == 1 && this.numTextures > 0) {
            this.facesTexture = new short[this.numFaces];
        }
        this.facesColor = new short[this.numFaces];
        if (this.numTextures > 0) {
            this.textureMappingP = new short[this.numTextures];
            this.textureMappingM = new short[this.numTextures];
            this.textureMappingN = new short[this.numTextures];
            if (complexTextureFaceCount > 0) {
                this.textureScaleX = new int[complexTextureFaceCount];
                this.textureScaleY = new int[complexTextureFaceCount];
                this.textureScaleZ = new int[complexTextureFaceCount];
                this.textureRotation = new byte[complexTextureFaceCount];
                this.textureDirection = new byte[complexTextureFaceCount];
                this.textureSpeed = new int[complexTextureFaceCount];
            }
            if (cubeTextureFaceCount > 0) {
                this.textureTransU = new int[cubeTextureFaceCount];
                this.textureTransV = new int[cubeTextureFaceCount];
            }
        }
        first.offset = verticesFlagOffset;
        second.offset = verticesXOffset;
        third.offset = verticesYOffset;
        fourth.offset = verticesZOffset;
        fifth.offset = verticesSkinOffset;
        int baseX = 0;
        int baseY = 0;
        int baseZ = 0;
        int vertex = 0;
        while (vertex < this.numVertices) {
            int flag = first.readUnsignedByte();
            int offsetX = 0;
            if ((flag & 1) != 0) {
                offsetX = second.readUnsignedSmart();
            }
            int offsetY = 0;
            if ((flag & 2) != 0) {
                offsetY = third.readUnsignedSmart();
            }
            int offsetZ = 0;
            if ((flag & 4) != 0) {
                offsetZ = fourth.readUnsignedSmart();
            }
            this.verticesX[vertex] = baseX + offsetX;
            this.verticesY[vertex] = baseY + offsetY;
            this.verticesZ[vertex] = baseZ + offsetZ;
            baseX = this.verticesX[vertex];
            baseY = this.verticesY[vertex];
            baseZ = this.verticesZ[vertex];
            if (hasVertexSkins == 1) {
                this.vertexSkins[vertex] = fifth.readUnsignedByte();
            }
            ++vertex;
        }
        first.offset = facesColorOffset;
        second.offset = facesTypeOffset;
        third.offset = facesPriorityOffset;
        fourth.offset = facesAlphaOffset;
        fifth.offset = facesSkinOffset;
        sixth.offset = facesMaterialOffset;
        seventh.offset = facesTextureIndexOffset;
        int face3 = 0;
        while (face3 < this.numFaces) {
            this.facesColor[face3] = (short)first.readUnsignedShort();
            if (hasFaceTypes) {
                this.facesType[face3] = second.readByte();
            }
            if (modelPriority == 255) {
                this.facesPriority[face3] = third.readByte();
            }
            if (hasAlphas == 1) {
                this.facesAlpha[face3] = fourth.readByte();
            }
            if (hasFaceSkins == 1) {
                this.facesSkins[face3] = fifth.readUnsignedByte();
            }
            if (hasMaterials == 1) {
                this.facesMaterial[face3] = (short)(sixth.readUnsignedShort() - 1);
            }
            if (this.facesTexture != null) {
                this.facesTexture[face3] = this.facesMaterial[face3] != -1 ? (int)(seventh.readUnsignedByte() - 1) : -1;
            }
            ++face3;
        }
        this.maxIndex = -1;
        first.offset = facesIndexOffset;
        second.offset = facesCompressTypeOffset;
        this.decodeIndices(first, second);
        first.offset = simpleTexturesOffset;
        second.offset = complexTexturesOffset;
        third.offset = texturesScaleOffset;
        fourth.offset = texturesRotationOffset;
        fifth.offset = texturesDirectionOffset;
        sixth.offset = texturesTranslationOffset;
        this.decodeMapping(first, second, third, fourth, fifth, sixth);
        first.offset = particlesEffectOFfset;
        if (hasParticleEffects) {
            int numEffectors;
            int numEmitters = first.readUnsignedByte();
            if (numEmitters > 0) {
                this.emitters = new EmissiveTriangle[numEmitters];
                int index = 0;
                while (index < numEmitters) {
                    int emitter = first.readUnsignedShort();
                    face = first.readUnsignedShort();
                    byte emitterPriority = modelPriority == 255 ? this.facesPriority[face] : (byte)modelPriority;
                    this.emitters[index] = new EmissiveTriangle(emitter, face, this.facesA[face], this.facesB[face], this.facesC[face], emitterPriority);
                    ++index;
                }
            }
            if ((numEffectors = first.readUnsignedByte()) > 0) {
                this.effectors = new EffectiveVertex[numEffectors];
                int index = 0;
                while (index < numEffectors) {
                    int effector = first.readUnsignedShort();
                    int vertex2 = first.readUnsignedShort();
                    this.effectors[index] = new EffectiveVertex(effector, vertex2);
                    ++index;
                }
            }
        }
        if (hasbillboards && (numBillboards = first.readUnsignedByte()) > 0) {
            this.billboards = new Billboard[numBillboards];
            int i_72_ = 0;
            while (i_72_ < numBillboards) {
                int id = first.readUnsignedShort();
                face = first.readUnsignedShort();
                int depth = first.readUnsignedByte();
                byte distance = first.readByte();
                this.billboards[i_72_] = new Billboard(id, face, depth, distance);
                ++i_72_;
            }
        }
    }

    void decodeRS3(byte[] data) {
        Packet first = new Packet(data);
        Packet second = new Packet(data);
        Packet third = new Packet(data);
        Packet fourth = new Packet(data);
        Packet fifth = new Packet(data);
        Packet sixth = new Packet(data);
        Packet seventh = new Packet(data);
        int magic = first.readUnsignedByte();
        if (magic != 1) {
            System.out.println("Error loading model - unexpected mesh magic code:" + magic);
        } else {
            int numBillboards;
            int face;
            int index;
            int offset;
            first.readUnsignedByte();
            this.version = first.readUnsignedByte();
            first.offset = data.length - 26;
            this.numVertices = first.readUnsignedShort();
            this.numFaces = first.readUnsignedShort();
            this.numTextures = first.readUnsignedShort();
            int flag = first.readUnsignedByte();
            boolean hasFaceTypes = (flag & 1) == 1;
            boolean hasParticleEffects = (flag & 2) == 2;
            boolean hasBillboards = (flag & 4) == 4;
            boolean hasExtendedVertexSkins = (flag & 0x10) == 16;
            boolean hasExtendedTriangleSkins = (flag & 0x20) == 32;
            boolean hasExtendedBillboards = (flag & 0x40) == 64;
            boolean hasUVCoordinates = (flag & 0x80) == 128;
            int modelPriority = first.readUnsignedByte();
            int modelAlpha = first.readUnsignedByte();
            int modelTriangleSkinValue = first.readUnsignedByte();
            int modelTexture = first.readUnsignedByte();
            int modelVertexSkins = first.readUnsignedByte();
            int modelVerticesX = first.readUnsignedShort();
            int modelVerticesY = first.readUnsignedShort();
            int modelVerticesZ = first.readUnsignedShort();
            int modelVertexPoint = first.readUnsignedShort();
            int modelTextureCoords = first.readUnsignedShort();
            int vertices = first.readUnsignedShort();
            int triangles = first.readUnsignedShort();
            if (!hasExtendedVertexSkins) {
                vertices = modelVertexSkins == 1 ? this.numVertices : 0;
            }
            if (!hasExtendedTriangleSkins) {
                triangles = modelTriangleSkinValue == 1 ? this.numFaces : 0;
            }
            int simpleTextureFaceCount = 0;
            int complexTextureFaceCount = 0;
            int cubeTextureFaceCount = 0;
            if (this.numTextures > 0) {
                this.textureMappings = new byte[this.numTextures];
                first.offset = 3;
                int face2 = 0;
                while (face2 < this.numTextures) {
                    this.textureMappings[face2] = first.readByte();
                    byte type = this.textureMappings[face2];
                    if (type == 0) {
                        ++simpleTextureFaceCount;
                    }
                    if (type >= 1 && type <= 3) {
                        ++complexTextureFaceCount;
                    }
                    if (type == 2) {
                        ++cubeTextureFaceCount;
                    }
                    ++face2;
                }
            }
            int vertexFlagsOffset = offset = this.numTextures + 3;
            int faceTypesOffset = offset += this.numVertices;
            if (hasFaceTypes) {
                offset += this.numFaces;
            }
            int facesCompressTypeOffset = offset;
            int facePrioritiesOffset = offset += this.numFaces;
            if (modelPriority == 255) {
                offset += this.numFaces;
            }
            int faceSkinsOffset = offset;
            int vertexSkinsOffset = offset += triangles;
            int faceAlphasOffset = offset += vertices;
            if (modelAlpha == 1) {
                offset += this.numFaces;
            }
            int faceIndicesOffset = offset;
            int faceMaterialsOffset = offset += modelVertexPoint;
            if (modelTexture == 1) {
                offset += this.numFaces * 2;
            }
            int faceTextureIndicesOffset = offset;
            int faceColorsOffset = offset += modelTextureCoords;
            int vertexXOffsetOffset = offset += this.numFaces * 2;
            int vertexYOffsetOffset = offset += modelVerticesX;
            int vertexZOffsetOffset = offset += modelVerticesY;
            int simpleTexturesOffset = offset += modelVerticesZ;
            int complexTexturesOffset = offset += simpleTextureFaceCount * 6;
            offset += complexTextureFaceCount * 6;
            int textureBytes = 6;
            if (this.version == 14) {
                textureBytes = 7;
            } else if (this.version >= 15) {
                textureBytes = 9;
            }
            int texturesScaleOffset = offset;
            int texturesRotationOffset = offset += complexTextureFaceCount * textureBytes;
            int texturesDirectionOffset = offset += complexTextureFaceCount;
            int texturesTranslationOffset = offset += complexTextureFaceCount;
            int particleEffectsOffset = offset += complexTextureFaceCount + cubeTextureFaceCount * 2;
            int texCoordSPos = data.length;
            int texCoordTPos = data.length;
            int texCoordUPos = data.length;
            int texCoordVPos = data.length;
            if (hasUVCoordinates) {
                Packet uvbuffer = new Packet(data);
                uvbuffer.offset = data.length - 26;
                uvbuffer.offset -= data[uvbuffer.offset - 1];
                this.numUVCoords = uvbuffer.readUnsignedShort();
                int i_139_ = uvbuffer.readUnsignedShort();
                int i_140_ = uvbuffer.readUnsignedShort();
                texCoordSPos = particleEffectsOffset + i_139_;
                texCoordTPos = texCoordSPos + i_140_;
                texCoordUPos = texCoordTPos + this.numVertices;
                texCoordVPos = texCoordUPos + this.numUVCoords * 2;
            }
            this.verticesX = new int[this.numVertices];
            this.verticesY = new int[this.numVertices];
            this.verticesZ = new int[this.numVertices];
            this.facesA = new short[this.numFaces];
            this.facesB = new short[this.numFaces];
            this.facesC = new short[this.numFaces];
            if (modelVertexSkins == 1) {
                this.vertexSkins = new int[this.numVertices];
            }
            if (hasFaceTypes) {
                this.facesType = new byte[this.numFaces];
            }
            if (modelPriority == 255) {
                this.facesPriority = new byte[this.numFaces];
            } else {
                this.priority = (byte)modelPriority;
            }
            if (modelAlpha == 1) {
                this.facesAlpha = new byte[this.numFaces];
            }
            if (modelTriangleSkinValue == 1) {
                this.facesSkins = new int[this.numFaces];
            }
            if (modelTexture == 1) {
                this.facesMaterial = new short[this.numFaces];
            }
            if (modelTexture == 1 && (this.numTextures > 0 || this.numUVCoords > 0)) {
                this.facesTexture = new short[this.numFaces];
            }
            this.facesColor = new short[this.numFaces];
            if (this.numTextures > 0) {
                this.textureMappingP = new short[this.numTextures];
                this.textureMappingM = new short[this.numTextures];
                this.textureMappingN = new short[this.numTextures];
                if (complexTextureFaceCount > 0) {
                    this.textureScaleX = new int[complexTextureFaceCount];
                    this.textureScaleY = new int[complexTextureFaceCount];
                    this.textureScaleZ = new int[complexTextureFaceCount];
                    this.textureRotation = new byte[complexTextureFaceCount];
                    this.textureDirection = new byte[complexTextureFaceCount];
                    this.textureSpeed = new int[complexTextureFaceCount];
                }
                if (cubeTextureFaceCount > 0) {
                    this.textureTransU = new int[cubeTextureFaceCount];
                    this.textureTransV = new int[cubeTextureFaceCount];
                }
            }
            first.offset = vertexFlagsOffset;
            second.offset = vertexXOffsetOffset;
            third.offset = vertexYOffsetOffset;
            fourth.offset = vertexZOffsetOffset;
            fifth.offset = vertexSkinsOffset;
            int baseX = 0;
            int baseY = 0;
            int baseZ = 0;
            int vertex = 0;
            while (vertex < this.numVertices) {
                int i_145_ = first.readUnsignedByte();
                int xoff = 0;
                if ((i_145_ & 1) != 0) {
                    xoff = second.readUnsignedSmart();
                }
                int yoff = 0;
                if ((i_145_ & 2) != 0) {
                    yoff = third.readUnsignedSmart();
                }
                int i_148_ = 0;
                if ((i_145_ & 4) != 0) {
                    i_148_ = fourth.readUnsignedSmart();
                }
                this.verticesX[vertex] = baseX + xoff;
                this.verticesY[vertex] = baseY + yoff;
                this.verticesZ[vertex] = baseZ + i_148_;
                baseX = this.verticesX[vertex];
                baseY = this.verticesY[vertex];
                baseZ = this.verticesZ[vertex];
                if (modelVertexSkins == 1) {
                    if (hasExtendedVertexSkins) {
                        this.vertexSkins[vertex] = fifth.readSmartNS();
                    } else {
                        this.vertexSkins[vertex] = fifth.readUnsignedByte();
                        if (this.vertexSkins[vertex] == 255) {
                            this.vertexSkins[vertex] = -1;
                        }
                    }
                }
                ++vertex;
            }
            if (this.numUVCoords > 0) {
                first.offset = texCoordTPos;
                second.offset = texCoordUPos;
                third.offset = texCoordVPos;
                this.vertexUVOffset = new int[this.numVertices];
                int index2 = 0;
                int i_150_ = 0;
                while (index2 < this.numVertices) {
                    this.vertexUVOffset[index2] = i_150_;
                    i_150_ += first.readUnsignedByte();
                    ++index2;
                }
                this.texCoordVertexA = new byte[this.numFaces];
                this.texCoordVertexB = new byte[this.numFaces];
                this.texCoordVertexC = new byte[this.numFaces];
                this.textureCoordU = new float[this.numUVCoords];
                this.textureCoordV = new float[this.numUVCoords];
                index2 = 0;
                while (index2 < this.numUVCoords) {
                    this.textureCoordU[index2] = (float)second.readShort() / 4096.0f;
                    this.textureCoordV[index2] = (float)third.readShort() / 4096.0f;
                    ++index2;
                }
            }
            first.offset = faceColorsOffset;
            second.offset = faceTypesOffset;
            third.offset = facePrioritiesOffset;
            fourth.offset = faceAlphasOffset;
            fifth.offset = faceSkinsOffset;
            sixth.offset = faceMaterialsOffset;
            seventh.offset = faceTextureIndicesOffset;
            int face3 = 0;
            while (face3 < this.numFaces) {
                this.facesColor[face3] = (short)first.readUnsignedShort();
                if (hasFaceTypes) {
                    this.facesType[face3] = second.readByte();
                }
                if (modelPriority == 255) {
                    this.facesPriority[face3] = third.readByte();
                }
                if (modelAlpha == 1) {
                    this.facesAlpha[face3] = fourth.readByte();
                }
                if (modelTriangleSkinValue == 1) {
                    if (hasExtendedTriangleSkins) {
                        this.facesSkins[face3] = fifth.readSmart();
                    } else {
                        this.facesSkins[face3] = fifth.readUnsignedByte();
                        if (this.facesSkins[face3] == 255) {
                            this.facesSkins[face3] = -1;
                        }
                    }
                }
                if (modelTexture == 1) {
                    this.facesMaterial[face3] = (short)(sixth.readUnsignedShort() - 1);
                }
                if (this.facesTexture != null) {
                    this.facesTexture[face3] = this.facesMaterial[face3] != -1 ? (this.version >= 16 ? (int)(seventh.readSmart() - 1) : (int)(seventh.readUnsignedByte() - 1)) : -1;
                }
                ++face3;
            }
            this.maxIndex = -1;
            first.offset = faceIndicesOffset;
            second.offset = facesCompressTypeOffset;
            third.offset = texCoordSPos;
            this.decodeIndicesRS3(first, second, third);
            first.offset = simpleTexturesOffset;
            second.offset = complexTexturesOffset;
            third.offset = texturesScaleOffset;
            fourth.offset = texturesRotationOffset;
            fifth.offset = texturesDirectionOffset;
            sixth.offset = texturesTranslationOffset;
            this.decodeMapping(first, second, third, fourth, fifth, sixth);
            first.offset = particleEffectsOffset;
            if (hasParticleEffects) {
                int numEffectors;
                int numEmitters = first.readUnsignedByte();
                if (numEmitters > 0) {
                    this.emitters = new EmissiveTriangle[numEmitters];
                    index = 0;
                    while (index < numEmitters) {
                        int emitter = first.readUnsignedShort();
                        face = first.readUnsignedShort();
                        byte priority = modelPriority == 255 ? this.facesPriority[face] : (byte)modelPriority;
                        this.emitters[index] = new EmissiveTriangle(emitter, face, this.facesA[face], this.facesB[face], this.facesC[face], priority);
                        ++index;
                    }
                }
                if ((numEffectors = first.readUnsignedByte()) > 0) {
                    this.effectors = new EffectiveVertex[numEffectors];
                    int index3 = 0;
                    while (index3 < numEffectors) {
                        int effector = first.readUnsignedShort();
                        int vertex2 = first.readUnsignedShort();
                        this.effectors[index3] = new EffectiveVertex(effector, vertex2);
                        ++index3;
                    }
                }
            }
            if (hasBillboards && (numBillboards = first.readUnsignedByte()) > 0) {
                this.billboards = new Billboard[numBillboards];
                index = 0;
                while (index < numBillboards) {
                    int skin;
                    int id = first.readUnsignedShort();
                    face = first.readUnsignedShort();
                    if (hasExtendedBillboards) {
                        skin = first.readSmartNS();
                    } else {
                        skin = first.readUnsignedByte();
                        if (skin == 255) {
                            skin = -1;
                        }
                    }
                    byte distance = first.readByte();
                    this.billboards[index] = new Billboard(id, face, skin, distance);
                    ++index;
                }
            }
        }
    }

    void decodeLegacy(byte[] is) {
        int i_99_;
        boolean bool = false;
        boolean bool_86_ = false;
        Packet bytebuf = new Packet(is);
        Packet bytebuf_87_ = new Packet(is);
        Packet bytebuf_88_ = new Packet(is);
        Packet bytebuf_89_ = new Packet(is);
        Packet bytebuf_90_ = new Packet(is);
        bytebuf.offset = is.length - 18;
        this.numVertices = bytebuf.readUnsignedShort();
        this.numFaces = bytebuf.readUnsignedShort();
        this.numTextures = bytebuf.readUnsignedByte();
        int i = bytebuf.readUnsignedByte();
        int i_91_ = bytebuf.readUnsignedByte();
        int i_92_ = bytebuf.readUnsignedByte();
        int i_93_ = bytebuf.readUnsignedByte();
        int i_94_ = bytebuf.readUnsignedByte();
        int i_95_ = bytebuf.readUnsignedShort();
        int i_96_ = bytebuf.readUnsignedShort();
        int i_97_ = bytebuf.readUnsignedShort();
        int i_98_ = bytebuf.readUnsignedShort();
        int i_100_ = i_99_ = 0;
        int i_101_ = i_99_ += this.numVertices;
        int i_102_ = i_99_ += this.numFaces;
        if (i_91_ == 255) {
            i_99_ += this.numFaces;
        }
        int i_103_ = i_99_;
        if (i_93_ == 1) {
            i_99_ += this.numFaces;
        }
        int i_104_ = i_99_;
        if (i == 1) {
            i_99_ += this.numFaces;
        }
        int i_105_ = i_99_;
        if (i_94_ == 1) {
            i_99_ += this.numVertices;
        }
        int i_106_ = i_99_;
        if (i_92_ == 1) {
            i_99_ += this.numFaces;
        }
        int i_107_ = i_99_;
        int i_108_ = i_99_ += i_98_;
        int i_109_ = i_99_ += this.numFaces * 2;
        int i_110_ = i_99_ += this.numTextures * 6;
        int i_111_ = i_99_ += i_95_;
        int i_112_ = i_99_ += i_96_;
        i_99_ += i_97_;
        this.verticesX = new int[this.numVertices];
        this.verticesY = new int[this.numVertices];
        this.verticesZ = new int[this.numVertices];
        this.facesA = new short[this.numFaces];
        this.facesB = new short[this.numFaces];
        this.facesC = new short[this.numFaces];
        if (this.numTextures > 0) {
            this.textureMappings = new byte[this.numTextures];
            this.textureMappingP = new short[this.numTextures];
            this.textureMappingM = new short[this.numTextures];
            this.textureMappingN = new short[this.numTextures];
        }
        if (i_94_ == 1) {
            this.vertexSkins = new int[this.numVertices];
        }
        if (i == 1) {
            this.facesType = new byte[this.numFaces];
            this.facesTexture = new short[this.numFaces];
            this.facesMaterial = new short[this.numFaces];
        }
        if (i_91_ == 255) {
            this.facesPriority = new byte[this.numFaces];
        } else {
            this.priority = (byte)i_91_;
        }
        if (i_92_ == 1) {
            this.facesAlpha = new byte[this.numFaces];
        }
        if (i_93_ == 1) {
            this.facesSkins = new int[this.numFaces];
        }
        this.facesColor = new short[this.numFaces];
        bytebuf.offset = i_100_;
        bytebuf_87_.offset = i_110_;
        bytebuf_88_.offset = i_111_;
        bytebuf_89_.offset = i_112_;
        bytebuf_90_.offset = i_105_;
        int i_113_ = 0;
        int i_114_ = 0;
        int i_115_ = 0;
        int i_116_ = 0;
        while (i_116_ < this.numVertices) {
            int i_117_ = bytebuf.readUnsignedByte();
            int i_118_ = 0;
            if ((i_117_ & 1) != 0) {
                i_118_ = bytebuf_87_.readUnsignedSmart();
            }
            int i_119_ = 0;
            if ((i_117_ & 2) != 0) {
                i_119_ = bytebuf_88_.readUnsignedSmart();
            }
            int i_120_ = 0;
            if ((i_117_ & 4) != 0) {
                i_120_ = bytebuf_89_.readUnsignedSmart();
            }
            this.verticesX[i_116_] = i_113_ + i_118_;
            this.verticesY[i_116_] = i_114_ + i_119_;
            this.verticesZ[i_116_] = i_115_ + i_120_;
            i_113_ = this.verticesX[i_116_];
            i_114_ = this.verticesY[i_116_];
            i_115_ = this.verticesZ[i_116_];
            if (i_94_ == 1) {
                this.vertexSkins[i_116_] = bytebuf_90_.readUnsignedByte();
            }
            ++i_116_;
        }
        bytebuf.offset = i_108_;
        bytebuf_87_.offset = i_104_;
        bytebuf_88_.offset = i_102_;
        bytebuf_89_.offset = i_106_;
        bytebuf_90_.offset = i_103_;
        int i_121_ = 0;
        while (i_121_ < this.numFaces) {
            this.facesColor[i_121_] = (short)bytebuf.readUnsignedShort();
            if (i == 1) {
                int i_122_ = bytebuf_87_.readUnsignedByte();
                if ((i_122_ & 1) == 1) {
                    this.facesType[i_121_] = 1;
                    bool = true;
                } else {
                    this.facesType[i_121_] = 0;
                }
                if ((i_122_ & 2) == 2) {
                    this.facesTexture[i_121_] = (short)(i_122_ >> 2);
                    this.facesMaterial[i_121_] = this.facesColor[i_121_];
                    this.facesColor[i_121_] = 127;
                    if (this.facesMaterial[i_121_] != -1) {
                        bool_86_ = true;
                    }
                } else {
                    this.facesTexture[i_121_] = -1;
                    this.facesMaterial[i_121_] = -1;
                }
            }
            if (i_91_ == 255) {
                this.facesPriority[i_121_] = bytebuf_88_.readByte();
            }
            if (i_92_ == 1) {
                this.facesAlpha[i_121_] = bytebuf_89_.readByte();
            }
            if (i_93_ == 1) {
                this.facesSkins[i_121_] = bytebuf_90_.readUnsignedByte();
            }
            ++i_121_;
        }
        this.maxIndex = -1;
        bytebuf.offset = i_107_;
        bytebuf_87_.offset = i_101_;
        short i_123_ = 0;
        short i_124_ = 0;
        short i_125_ = 0;
        int i_126_ = 0;
        int i_127_ = 0;
        while (i_127_ < this.numFaces) {
            int i_128_ = bytebuf_87_.readUnsignedByte();
            if (i_128_ == 1) {
                i_123_ = (short)(bytebuf.readUnsignedSmart() + i_126_);
                i_126_ = i_123_;
                i_124_ = (short)(bytebuf.readUnsignedSmart() + i_126_);
                i_126_ = i_124_;
                i_125_ = (short)(bytebuf.readUnsignedSmart() + i_126_);
                i_126_ = i_125_;
                this.facesA[i_127_] = i_123_;
                this.facesB[i_127_] = i_124_;
                this.facesC[i_127_] = i_125_;
                if (i_123_ > this.maxIndex) {
                    this.maxIndex = i_123_;
                }
                if (i_124_ > this.maxIndex) {
                    this.maxIndex = i_124_;
                }
                if (i_125_ > this.maxIndex) {
                    this.maxIndex = i_125_;
                }
            }
            if (i_128_ == 2) {
                i_124_ = i_125_;
                i_125_ = (short)(bytebuf.readUnsignedSmart() + i_126_);
                i_126_ = i_125_;
                this.facesA[i_127_] = i_123_;
                this.facesB[i_127_] = i_124_;
                this.facesC[i_127_] = i_125_;
                if (i_125_ > this.maxIndex) {
                    this.maxIndex = i_125_;
                }
            }
            if (i_128_ == 3) {
                i_123_ = i_125_;
                i_125_ = (short)(bytebuf.readUnsignedSmart() + i_126_);
                i_126_ = i_125_;
                this.facesA[i_127_] = i_123_;
                this.facesB[i_127_] = i_124_;
                this.facesC[i_127_] = i_125_;
                if (i_125_ > this.maxIndex) {
                    this.maxIndex = i_125_;
                }
            }
            if (i_128_ == 4) {
                short i_129_ = i_123_;
                i_123_ = i_124_;
                i_124_ = i_129_;
                i_125_ = (short)(bytebuf.readUnsignedSmart() + i_126_);
                i_126_ = i_125_;
                this.facesA[i_127_] = i_123_;
                this.facesB[i_127_] = i_124_;
                this.facesC[i_127_] = i_125_;
                if (i_125_ > this.maxIndex) {
                    this.maxIndex = i_125_;
                }
            }
            ++i_127_;
        }
        ++this.maxIndex;
        bytebuf.offset = i_109_;
        int i_130_ = 0;
        while (i_130_ < this.numTextures) {
            this.textureMappings[i_130_] = 0;
            this.textureMappingP[i_130_] = (short)bytebuf.readUnsignedShort();
            this.textureMappingM[i_130_] = (short)bytebuf.readUnsignedShort();
            this.textureMappingN[i_130_] = (short)bytebuf.readUnsignedShort();
            ++i_130_;
        }
        if (this.facesTexture != null) {
            boolean bool_131_ = false;
            int i_132_ = 0;
            while (i_132_ < this.numFaces) {
                int i_133_ = this.facesTexture[i_132_] & 0xFF;
                if (i_133_ != 255) {
                    if ((this.textureMappingP[i_133_] & 0xFFFF) == this.facesA[i_132_] && (this.textureMappingM[i_133_] & 0xFFFF) == this.facesB[i_132_] && (this.textureMappingN[i_133_] & 0xFFFF) == this.facesC[i_132_]) {
                        this.facesTexture[i_132_] = -1;
                    } else {
                        bool_131_ = true;
                    }
                }
                ++i_132_;
            }
            if (!bool_131_) {
                this.facesTexture = null;
            }
        }
        if (!bool_86_) {
            this.facesMaterial = null;
        }
        if (!bool) {
            this.facesType = null;
        }
    }

    void decodeMapping(Packet bytebuf, Packet bytebuf_80_, Packet bytebuf_81_, Packet bytebuf_82_, Packet bytebuf_83_, Packet bytebuf_84_) {
        int i = 0;
        while (i < this.numTextures) {
            int i_85_ = this.textureMappings[i] & 0xFF;
            if (i_85_ == 0) {
                this.textureMappingP[i] = (short)bytebuf.readUnsignedShort();
                this.textureMappingM[i] = (short)bytebuf.readUnsignedShort();
                this.textureMappingN[i] = (short)bytebuf.readUnsignedShort();
            }
            if (i_85_ == 1) {
                this.textureMappingP[i] = (short)bytebuf_80_.readUnsignedShort();
                this.textureMappingM[i] = (short)bytebuf_80_.readUnsignedShort();
                this.textureMappingN[i] = (short)bytebuf_80_.readUnsignedShort();
                if (this.version < 15) {
                    this.textureScaleX[i] = bytebuf_81_.readUnsignedShort();
                    this.textureScaleY[i] = this.version < 14 ? bytebuf_81_.readUnsignedShort() : bytebuf_81_.readUnsignedTriByte();
                    this.textureScaleZ[i] = bytebuf_81_.readUnsignedShort();
                } else {
                    this.textureScaleX[i] = bytebuf_81_.readUnsignedTriByte();
                    this.textureScaleY[i] = bytebuf_81_.readUnsignedTriByte();
                    this.textureScaleZ[i] = bytebuf_81_.readUnsignedTriByte();
                }
                this.textureRotation[i] = bytebuf_82_.readByte();
                this.textureDirection[i] = bytebuf_83_.readByte();
                this.textureSpeed[i] = bytebuf_84_.readByte();
            }
            if (i_85_ == 2) {
                this.textureMappingP[i] = (short)bytebuf_80_.readUnsignedShort();
                this.textureMappingM[i] = (short)bytebuf_80_.readUnsignedShort();
                this.textureMappingN[i] = (short)bytebuf_80_.readUnsignedShort();
                if (this.version < 15) {
                    this.textureScaleX[i] = bytebuf_81_.readUnsignedShort();
                    this.textureScaleY[i] = this.version < 14 ? bytebuf_81_.readUnsignedShort() : bytebuf_81_.readUnsignedTriByte();
                    this.textureScaleZ[i] = bytebuf_81_.readUnsignedShort();
                } else {
                    this.textureScaleX[i] = bytebuf_81_.readUnsignedTriByte();
                    this.textureScaleY[i] = bytebuf_81_.readUnsignedTriByte();
                    this.textureScaleZ[i] = bytebuf_81_.readUnsignedTriByte();
                }
                this.textureRotation[i] = bytebuf_82_.readByte();
                this.textureDirection[i] = bytebuf_83_.readByte();
                this.textureSpeed[i] = bytebuf_84_.readByte();
                this.textureTransU[i] = bytebuf_84_.readByte();
                this.textureTransV[i] = bytebuf_84_.readByte();
            }
            if (i_85_ == 3) {
                this.textureMappingP[i] = (short)bytebuf_80_.readUnsignedShort();
                this.textureMappingM[i] = (short)bytebuf_80_.readUnsignedShort();
                this.textureMappingN[i] = (short)bytebuf_80_.readUnsignedShort();
                if (this.version < 15) {
                    this.textureScaleX[i] = bytebuf_81_.readUnsignedShort();
                    this.textureScaleY[i] = this.version < 14 ? bytebuf_81_.readUnsignedShort() : bytebuf_81_.readUnsignedTriByte();
                    this.textureScaleZ[i] = bytebuf_81_.readUnsignedShort();
                } else {
                    this.textureScaleX[i] = bytebuf_81_.readUnsignedTriByte();
                    this.textureScaleY[i] = bytebuf_81_.readUnsignedTriByte();
                    this.textureScaleZ[i] = bytebuf_81_.readUnsignedTriByte();
                }
                this.textureRotation[i] = bytebuf_82_.readByte();
                this.textureDirection[i] = bytebuf_83_.readByte();
                this.textureSpeed[i] = bytebuf_84_.readByte();
            }
            ++i;
        }
    }

    void decodeIndices(Packet bytebuf, Packet bytebuf_222_) {
        short i = 0;
        short i_223_ = 0;
        short i_224_ = 0;
        int i_225_ = 0;
        int i_226_ = 0;
        while (i_226_ < this.numFaces) {
            int i_227_ = bytebuf_222_.readUnsignedByte();
            if (i_227_ == 1) {
                i = (short)(bytebuf.readUnsignedSmart() + i_225_);
                i_225_ = i;
                i_223_ = (short)(bytebuf.readUnsignedSmart() + i_225_);
                i_225_ = i_223_;
                i_224_ = (short)(bytebuf.readUnsignedSmart() + i_225_);
                i_225_ = i_224_;
                this.facesA[i_226_] = i;
                this.facesB[i_226_] = i_223_;
                this.facesC[i_226_] = i_224_;
                if (i > this.maxIndex) {
                    this.maxIndex = i;
                }
                if (i_223_ > this.maxIndex) {
                    this.maxIndex = i_223_;
                }
                if (i_224_ > this.maxIndex) {
                    this.maxIndex = i_224_;
                }
            }
            if (i_227_ == 2) {
                i_223_ = i_224_;
                i_224_ = (short)(bytebuf.readUnsignedSmart() + i_225_);
                i_225_ = i_224_;
                this.facesA[i_226_] = i;
                this.facesB[i_226_] = i_223_;
                this.facesC[i_226_] = i_224_;
                if (i_224_ > this.maxIndex) {
                    this.maxIndex = i_224_;
                }
            }
            if (i_227_ == 3) {
                i = i_224_;
                i_224_ = (short)(bytebuf.readUnsignedSmart() + i_225_);
                i_225_ = i_224_;
                this.facesA[i_226_] = i;
                this.facesB[i_226_] = i_223_;
                this.facesC[i_226_] = i_224_;
                if (i_224_ > this.maxIndex) {
                    this.maxIndex = i_224_;
                }
            }
            if (i_227_ == 4) {
                short i_228_ = i;
                i = i_223_;
                i_223_ = i_228_;
                i_224_ = (short)(bytebuf.readUnsignedSmart() + i_225_);
                i_225_ = i_224_;
                this.facesA[i_226_] = i;
                this.facesB[i_226_] = i_223_;
                this.facesC[i_226_] = i_224_;
                if (i_224_ > this.maxIndex) {
                    this.maxIndex = i_224_;
                }
            }
            ++i_226_;
        }
        ++this.maxIndex;
    }

    void decodeIndicesRS3(Packet indicesBuffer, Packet typesBuffer, Packet texturesBuffer) {
        short i = 0;
        short i_223_ = 0;
        short i_224_ = 0;
        int i_225_ = 0;
        int face = 0;
        while (face < this.numFaces) {
            int flag = typesBuffer.readUnsignedByte();
            int type = flag & 7;
            if (type == 1) {
                i = (short)(indicesBuffer.readUnsignedSmart() + i_225_);
                i_225_ = i;
                i_223_ = (short)(indicesBuffer.readUnsignedSmart() + i_225_);
                i_225_ = i_223_;
                i_224_ = (short)(indicesBuffer.readUnsignedSmart() + i_225_);
                i_225_ = i_224_;
                this.facesA[face] = i;
                this.facesB[face] = i_223_;
                this.facesC[face] = i_224_;
                if (i > this.maxIndex) {
                    this.maxIndex = i;
                }
                if (i_223_ > this.maxIndex) {
                    this.maxIndex = i_223_;
                }
                if (i_224_ > this.maxIndex) {
                    this.maxIndex = i_224_;
                }
            }
            if (type == 2) {
                i_223_ = i_224_;
                i_224_ = (short)(indicesBuffer.readUnsignedSmart() + i_225_);
                i_225_ = i_224_;
                this.facesA[face] = i;
                this.facesB[face] = i_223_;
                this.facesC[face] = i_224_;
                if (i_224_ > this.maxIndex) {
                    this.maxIndex = i_224_;
                }
            }
            if (type == 3) {
                i = i_224_;
                i_224_ = (short)(indicesBuffer.readUnsignedSmart() + i_225_);
                i_225_ = i_224_;
                this.facesA[face] = i;
                this.facesB[face] = i_223_;
                this.facesC[face] = i_224_;
                if (i_224_ > this.maxIndex) {
                    this.maxIndex = i_224_;
                }
            }
            if (type == 4) {
                short i_228_ = i;
                i = i_223_;
                i_223_ = i_228_;
                i_224_ = (short)(indicesBuffer.readUnsignedSmart() + i_225_);
                i_225_ = i_224_;
                this.facesA[face] = i;
                this.facesB[face] = i_223_;
                this.facesC[face] = i_224_;
                if (i_224_ > this.maxIndex) {
                    this.maxIndex = i_224_;
                }
            }
            if (this.numUVCoords > 0 && (flag & 8) != 0) {
                this.texCoordVertexA[face] = (byte)texturesBuffer.readUnsignedByte();
                this.texCoordVertexB[face] = (byte)texturesBuffer.readUnsignedByte();
                this.texCoordVertexC[face] = (byte)texturesBuffer.readUnsignedByte();
            }
            ++face;
        }
        ++this.maxIndex;
    }

    public void translate(int i, int i_77_, int i_78_) {
        int i_79_ = 0;
        while (i_79_ < this.numVertices) {
            int n = i_79_;
            this.verticesX[n] = this.verticesX[n] + i;
            int n2 = i_79_;
            this.verticesY[n2] = this.verticesY[n2] + i_77_;
            int n3 = i_79_++;
            this.verticesZ[n3] = this.verticesZ[n3] + i_78_;
        }
    }

    int addVertex(Mesh source, int index, short i_1_) {
        int i_2_ = source.verticesX[index];
        int i_3_ = source.verticesY[index];
        int i_4_ = source.verticesZ[index];
        int i_5_ = 0;
        while (i_5_ < this.numVertices) {
            if (i_2_ == this.verticesX[i_5_] && i_3_ == this.verticesY[i_5_] && i_4_ == this.verticesZ[i_5_]) {
                int n = i_5_;
                this.triangleIdentifiers[n] = (short)(this.triangleIdentifiers[n] | i_1_);
                return i_5_;
            }
            ++i_5_;
        }
        this.verticesX[this.numVertices] = i_2_;
        this.verticesY[this.numVertices] = i_3_;
        this.verticesZ[this.numVertices] = i_4_;
        this.triangleIdentifiers[this.numVertices] = i_1_;
        this.vertexSkins[this.numVertices] = source.vertexSkins != null ? source.vertexSkins[index] : -1;
        return this.numVertices++;
    }

    public int addVertex(int i, int i_134_, int i_135_) {
        int i_136_ = 0;
        while (i_136_ < this.numVertices) {
            if (this.verticesX[i_136_] == i && this.verticesY[i_136_] == i_134_ && this.verticesZ[i_136_] == i_135_) {
                return i_136_;
            }
            ++i_136_;
        }
        this.verticesX[this.numVertices] = i;
        this.verticesY[this.numVertices] = i_134_;
        this.verticesZ[this.numVertices] = i_135_;
        this.maxIndex = this.numVertices + 1;
        return this.numVertices++;
    }

    public int addFace(int i, int i_137_, int i_138_, byte i_139_, byte i_140_, short i_141_, byte i_142_, short i_143_) {
        this.facesA[this.numFaces] = (short)i;
        this.facesB[this.numFaces] = (short)i_137_;
        this.facesC[this.numFaces] = (short)i_138_;
        this.facesType[this.numFaces] = i_139_;
        this.facesTexture[this.numFaces] = i_140_;
        this.facesColor[this.numFaces] = i_141_;
        this.facesAlpha[this.numFaces] = i_142_;
        this.facesMaterial[this.numFaces] = i_143_;
        return this.numFaces++;
    }

    public byte addTexturedFace(short i, short i_206_, short i_207_, short i_208_, short i_209_, short i_210_, byte i_211_, byte i_212_, byte i_213_) {
        if (this.numTextures >= 255) {
            throw new IllegalStateException();
        }
        this.textureMappings[this.numTextures] = 3;
        this.textureMappingP[this.numTextures] = i;
        this.textureMappingM[this.numTextures] = i_206_;
        this.textureMappingN[this.numTextures] = i_207_;
        this.textureScaleX[this.numTextures] = i_208_;
        this.textureScaleY[this.numTextures] = i_209_;
        this.textureScaleZ[this.numTextures] = i_210_;
        this.textureRotation[this.numTextures] = i_211_;
        this.textureDirection[this.numTextures] = i_212_;
        this.textureSpeed[this.numTextures] = i_213_;
        return (byte)this.numTextures++;
    }

    public int[][] method908(boolean bool) {
        int[] is = new int[400];
        int i = 0;
        int i_172_ = bool ? this.numVertices : this.maxIndex;
        int i_173_ = 0;
        while (i_173_ < i_172_) {
            int i_174_ = this.vertexSkins[i_173_];
            if (i_174_ >= 0) {
                int n = i_174_;
                is[n] = is[n] + 1;
                if (i_174_ > i) {
                    i = i_174_;
                }
            }
            ++i_173_;
        }
        int[][] is_175_ = new int[i + 1][];
        int i_176_ = 0;
        while (i_176_ <= i) {
            is_175_[i_176_] = new int[is[i_176_]];
            is[i_176_] = 0;
            ++i_176_;
        }
        int i_177_ = 0;
        while (i_177_ < i_172_) {
            int i_178_ = this.vertexSkins[i_177_];
            if (i_178_ >= 0) {
                int n = i_178_;
                int n2 = is[n];
                is[n] = n2 + 1;
                is_175_[i_178_][n2] = i_177_;
            }
            ++i_177_;
        }
        return is_175_;
    }

    public int[][] method909() {
        int[] is = new int[256];
        int i = 0;
        int i_179_ = 0;
        while (i_179_ < this.billboards.length) {
            int i_180_ = this.billboards[i_179_].anInt1254;
            if (i_180_ >= 0) {
                int n = i_180_;
                is[n] = is[n] + 1;
                if (i_180_ > i) {
                    i = i_180_;
                }
            }
            ++i_179_;
        }
        int[][] is_181_ = new int[i + 1][];
        int i_182_ = 0;
        while (i_182_ <= i) {
            is_181_[i_182_] = new int[is[i_182_]];
            is[i_182_] = 0;
            ++i_182_;
        }
        int i_183_ = 0;
        while (i_183_ < this.billboards.length) {
            int i_184_ = this.billboards[i_183_].anInt1254;
            if (i_184_ >= 0) {
                int n = i_184_;
                int n2 = is[n];
                is[n] = n2 + 1;
                is_181_[i_184_][n2] = i_183_;
            }
            ++i_183_;
        }
        return is_181_;
    }

    public void recolor(short i, short i_185_) {
        int i_186_ = 0;
        while (i_186_ < this.numFaces) {
            if (this.facesColor[i_186_] == i) {
                this.facesColor[i_186_] = i_185_;
            }
            ++i_186_;
        }
    }

    public void rotate(int i, int i_190_, int i_191_) {
        if (i_191_ != 0) {
            int i_192_ = Class224.anIntArray2457[i_191_];
            int i_193_ = Class224.anIntArray2456[i_191_];
            int i_194_ = 0;
            while (i_194_ < this.numVertices) {
                int i_195_ = this.verticesY[i_194_] * i_192_ + this.verticesX[i_194_] * i_193_ >> 14;
                this.verticesY[i_194_] = this.verticesY[i_194_] * i_193_ - this.verticesX[i_194_] * i_192_ >> 14;
                this.verticesX[i_194_] = i_195_;
                ++i_194_;
            }
        }
        if (i != 0) {
            int i_196_ = Class224.anIntArray2457[i];
            int i_197_ = Class224.anIntArray2456[i];
            int i_198_ = 0;
            while (i_198_ < this.numVertices) {
                int i_199_ = this.verticesY[i_198_] * i_197_ - this.verticesZ[i_198_] * i_196_ >> 14;
                this.verticesZ[i_198_] = this.verticesY[i_198_] * i_196_ + this.verticesZ[i_198_] * i_197_ >> 14;
                this.verticesY[i_198_] = i_199_;
                ++i_198_;
            }
        }
        if (i_190_ != 0) {
            int i_200_ = Class224.anIntArray2457[i_190_];
            int i_201_ = Class224.anIntArray2456[i_190_];
            int i_202_ = 0;
            while (i_202_ < this.numVertices) {
                int i_203_ = this.verticesZ[i_202_] * i_200_ + this.verticesX[i_202_] * i_201_ >> 14;
                this.verticesZ[i_202_] = this.verticesZ[i_202_] * i_201_ - this.verticesX[i_202_] * i_200_ >> 14;
                this.verticesX[i_202_] = i_203_;
                ++i_202_;
            }
        }
    }

    public void scale(int i) {
        int i_204_ = 0;
        while (i_204_ < this.numVertices) {
            int n = i_204_;
            this.verticesX[n] = this.verticesX[n] << i;
            int n2 = i_204_;
            this.verticesY[n2] = this.verticesY[n2] << i;
            int n3 = i_204_++;
            this.verticesZ[n3] = this.verticesZ[n3] << i;
        }
        if (this.numTextures > 0 && this.textureScaleX != null) {
            int i_205_ = 0;
            while (i_205_ < this.textureScaleX.length) {
                int n = i_205_;
                this.textureScaleX[n] = this.textureScaleX[n] << i;
                int n4 = i_205_;
                this.textureScaleY[n4] = this.textureScaleY[n4] << i;
                if (this.textureMappings[i_205_] != 1) {
                    int n5 = i_205_;
                    this.textureScaleZ[n5] = this.textureScaleZ[n5] << i;
                }
                ++i_205_;
            }
        }
    }

    public void retexture(short i, short i_214_) {
        if (this.facesMaterial != null) {
            int i_215_ = 0;
            while (i_215_ < this.numFaces) {
                if (this.facesMaterial[i_215_] == i) {
                    this.facesMaterial[i_215_] = i_214_;
                }
                ++i_215_;
            }
        }
    }

    public int[][] method916() {
        int[] is = new int[256];
        int i = 0;
        int i_216_ = 0;
        while (i_216_ < this.numFaces) {
            int i_217_ = this.facesSkins[i_216_];
            if (i_217_ >= 0) {
                int n = i_217_;
                is[n] = is[n] + 1;
                if (i_217_ > i) {
                    i = i_217_;
                }
            }
            ++i_216_;
        }
        int[][] is_218_ = new int[i + 1][];
        int i_219_ = 0;
        while (i_219_ <= i) {
            is_218_[i_219_] = new int[is[i_219_]];
            is[i_219_] = 0;
            ++i_219_;
        }
        int i_220_ = 0;
        while (i_220_ < this.numFaces) {
            int i_221_ = this.facesSkins[i_220_];
            if (i_221_ >= 0) {
                int n = i_221_;
                int n2 = is[n];
                is[n] = n2 + 1;
                is_218_[i_221_][n2] = i_220_;
            }
            ++i_220_;
        }
        return is_218_;
    }

    public static Mesh fromJs5(Js5 archive, int i, int i_187_) {
        byte[] is = archive.getFile(i, i_187_);
        if (is == null) {
            return null;
        }
        return new Mesh(is);
    }

    public static void quicksort(int[] is, float[] fs, float[] fs_10_, byte i) {
        Mesh.quicksort(is, fs, fs_10_, 0, is.length - 1, 1274582430);
    }

    public static void quicksort(int[] is, float[] fs, float[] fs_2_, int i, int i_3_, int i_4_) {
        if (i < i_3_) {
            int i_5_ = (i_3_ + i) / 2;
            int i_6_ = i;
            int i_7_ = is[i_5_];
            is[i_5_] = is[i_3_];
            is[i_3_] = i_7_;
            float f = fs[i_5_];
            fs[i_5_] = fs[i_3_];
            fs[i_3_] = f;
            float f_8_ = fs_2_[i_5_];
            fs_2_[i_5_] = fs_2_[i_3_];
            fs_2_[i_3_] = f_8_;
            int i_9_ = Long.MAX_VALUE == (long)i_7_ ? 0 : 1;
            int i_10_ = i;
            while (i_10_ < i_3_) {
                if (is[i_10_] < i_7_ + (i_10_ & i_9_)) {
                    int i_11_ = is[i_10_];
                    is[i_10_] = is[i_6_];
                    is[i_6_] = i_11_;
                    float f_12_ = fs[i_10_];
                    fs[i_10_] = fs[i_6_];
                    fs[i_6_] = f_12_;
                    float f_13_ = fs_2_[i_10_];
                    fs_2_[i_10_] = fs_2_[i_6_];
                    fs_2_[i_6_] = f_13_;
                    ++i_6_;
                }
                ++i_10_;
            }
            is[i_3_] = is[i_6_];
            is[i_6_] = i_7_;
            fs[i_3_] = fs[i_6_];
            fs[i_6_] = f;
            fs_2_[i_3_] = fs_2_[i_6_];
            fs_2_[i_6_] = f_8_;
            Mesh.quicksort(is, fs, fs_2_, i, i_6_ - 1, 2043251314);
            Mesh.quicksort(is, fs, fs_2_, i_6_ + 1, i_3_, 1451267068);
        }
    }
}

